<?php
if (!function_exists('tpl_icon_html')) {
    function tpl_icon_html($icon, $title, $fallback, $imgStyle, $iconType)
    {
        $icon = trim((string)$icon);
        $iconType = trim((string)$iconType);
        if ($icon === '') {
            return '<i class="' . e($fallback) . '"></i>';
        }
        if ($iconType === 'image') {
            return '<img src="' . e($icon) . '" alt="' . e($title) . '" style="' . e($imgStyle) . '">';
        }
        if ($iconType !== 'font' && preg_match('#^(https?://|/)#i', $icon)) {
            return '<img src="' . e($icon) . '" alt="' . e($title) . '" style="' . e($imgStyle) . '">';
        }
        return '<i class="' . e($icon) . '"></i>';
    }
}
$siteName = isset($settings['site_name']) ? $settings['site_name'] : '导航页款式 15';
$siteSubtitle = isset($settings['site_subtitle']) ? $settings['site_subtitle'] : '';
$siteDescription = isset($settings['site_description']) ? $settings['site_description'] : '欢迎访问';
$copyright = isset($settings['copyright_text']) ? $settings['copyright_text'] : '';
$snowEnabled = isset($settings['snow_enabled']) && $settings['snow_enabled'] === '1';
$qqNumber = isset($settings['qq_number']) ? trim($settings['qq_number']) : '';
$qqGroup = isset($settings['qq_group']) ? trim($settings['qq_group']) : '';
$ctaLink = !empty($links) ? $links[0] : null;
$pillLinks = count($links) > 1 ? array_slice($links, 1) : $links;
?>
<!doctype html>
<html lang="zh-CN">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <title><?php echo e($siteName); ?></title>
    <link rel="stylesheet" href="//oss2.myoss.top/assets/libs/fontawesome-free-6.7.2-web/css/all.css">
    <style>
        :root {
            --bg1: #f7b7b9;
            --bg2: #c7daf8;
            --card: #ffffff;
            --muted: #8a8a8a;
            --shadow: 0 16px 32px rgba(0, 0, 0, 0.14);
        }

        * { box-sizing: border-box; }

        body {
            margin: 0;
            min-height: 100vh;
            font-family: "PingFang SC", "Microsoft YaHei", "Helvetica Neue", Arial, sans-serif;
            background: linear-gradient(135deg, var(--bg1), var(--bg2));
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 18px;
            color: #1f1f1f;
        }

        .card {
            width: min(420px, 100%);
            background: var(--card);
            border-radius: 18px;
            box-shadow: var(--shadow);
            padding: 22px 18px 20px;
            text-align: center;
        }

        .avatar {
            width: 94px;
            height: 94px;
            margin: 0 auto 14px;
            border-radius: 50%;
            background: linear-gradient(135deg, #ff8a9f, #ffb476);
            display: grid;
            place-items: center;
            box-shadow: 0 12px 20px rgba(0, 0, 0, 0.12);
            position: relative;
            color: #d81234;
            font-size: 34px;
        }

        .avatar::after {
            content: "15";
            position: absolute;
            right: 6px;
            bottom: 6px;
            background: #ff9a76;
            color: #fff;
            font-size: 12px;
            font-weight: 800;
            border-radius: 50%;
            padding: 4px 6px;
            box-shadow: 0 6px 10px rgba(0, 0, 0, 0.12);
        }

        h1 { margin: 0 0 6px; font-size: 22px; }
        .age { margin: 0 0 4px; color: #4a4a4a; font-size: 13px; }
        .quote { margin: 0 0 16px; color: #d45c8a; font-size: 13px; line-height: 1.6; }

        .cta {
            display: block;
            text-decoration: none;
            color: #fff;
            padding: 12px 16px;
            border-radius: 999px;
            background: linear-gradient(135deg, #00c7a4, #5abf3f);
            box-shadow: 0 12px 20px rgba(0, 0, 0, 0.12);
            font-weight: 800;
            margin-bottom: 18px;
        }

        .divider { height: 1px; background: #e7e7e7; margin: 10px 0 16px; }
        .title { color: #d14562; font-weight: 800; margin: 0 0 12px; letter-spacing: 0.5px; }

        .grid { display: grid; grid-template-columns: repeat(2, minmax(0, 1fr)); gap: 10px; }

        .pill {
            display: block;
            text-decoration: none;
            color: #fff;
            padding: 10px 12px;
            border-radius: 10px;
            font-weight: 700;
            background: linear-gradient(135deg, #5f58f8, #5a8bff);
            box-shadow: 0 10px 16px rgba(0, 0, 0, 0.08);
        }
        .pill:nth-child(odd) { background: linear-gradient(135deg, #6a3de8, #ff6db9); }

        .contact { margin-top: 16px; font-size: 12px; color: #7a7a7a; line-height: 1.7; }
        .contact a { color: #6a3de8; text-decoration: none; }

        #snowCanvas { position: fixed; inset: 0; z-index: 9999; pointer-events: none; }
    </style>
</head>
<body>
<div class="card">
    <div class="avatar"><i class="fa-solid fa-heart"></i></div>
    <h1><?php echo e($siteName); ?></h1>
    <p class="age"><?php echo e($siteSubtitle !== '' ? $siteSubtitle : '欢迎访问'); ?></p>
    <p class="quote"><?php echo e($siteDescription); ?></p>

    <?php if ($ctaLink): ?>
        <a class="cta" href="<?php echo e(front_nav_href($ctaLink)); ?>" target="_blank">
            <?php echo tpl_icon_html($ctaLink['icon'], $ctaLink['title'], 'fa-solid fa-link', 'width:16px;height:16px;border-radius:4px;object-fit:cover;vertical-align:-3px;margin-right:6px;', isset($ctaLink['icon_type']) ? $ctaLink['icon_type'] : ''); ?>
            <?php echo e($ctaLink['title']); ?>
        </a>
    <?php else: ?>
        <a class="cta" href="javascript:void(0)">点下康康</a>
    <?php endif; ?>

    <div class="divider"></div>
    <div class="title">旗下站点</div>
    <div class="grid">
        <?php if (empty($pillLinks)): ?>
            <a class="pill" href="javascript:void(0)">暂无站点</a>
        <?php else: ?>
            <?php foreach ($pillLinks as $item): ?>
                <a class="pill" href="<?php echo e(front_nav_href($item)); ?>" target="_blank"><?php echo e($item['title']); ?></a>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>

    <div class="contact">
        <?php if ($qqNumber !== '' || $qqGroup !== ''): ?>
            QQ：<?php echo e($qqNumber !== '' ? $qqNumber : '未设置'); ?>
            <?php if ($qqGroup !== ''): ?> | 群：<?php echo e($qqGroup); ?><?php endif; ?>
            <br>
        <?php endif; ?>
        <?php if ($copyright !== ''): ?><?php echo e($copyright); ?><?php endif; ?>
    </div>
</div>

<?php if ($snowEnabled): ?>
<canvas id="snowCanvas"></canvas>
<script>
(function () {
    var canvas = document.getElementById('snowCanvas');
    if (!canvas) return;
    var ctx = canvas.getContext('2d');
    var flakes = [];
    var count = 90;
    function resize() { canvas.width = window.innerWidth; canvas.height = window.innerHeight; }
    function reset(f) {
        f.x = Math.random() * canvas.width;
        f.y = Math.random() * canvas.height;
        f.r = 1 + Math.random() * 3;
        f.vx = -0.4 + Math.random() * 0.8;
        f.vy = 0.8 + Math.random() * 1.6;
    }
    for (var i = 0; i < count; i++) { var f = {}; reset(f); flakes.push(f); }
    function draw() {
        ctx.clearRect(0, 0, canvas.width, canvas.height);
        ctx.fillStyle = 'rgba(255,255,255,0.85)';
        for (var i = 0; i < flakes.length; i++) {
            var f = flakes[i];
            f.x += f.vx;
            f.y += f.vy;
            if (f.y > canvas.height || f.x < -20 || f.x > canvas.width + 20) { reset(f); f.y = -10; }
            ctx.beginPath(); ctx.arc(f.x, f.y, f.r, 0, Math.PI * 2); ctx.fill();
        }
        requestAnimationFrame(draw);
    }
    window.addEventListener('resize', resize); resize(); draw();
})();
</script>
<?php endif; ?>
</body>
</html>
