<?php
if (!function_exists('tpl_icon_html')) {
    function tpl_icon_html($icon, $title, $fallback, $iconType)
    {
        $icon = trim((string)$icon);
        $iconType = trim((string)$iconType);
        if ($icon === '') {
            return '<i class="' . e($fallback) . '"></i>';
        }
        if ($iconType === 'image') {
            return '<img src="' . e($icon) . '" alt="' . e($title) . '" style="width:16px;height:16px;border-radius:3px;object-fit:cover;vertical-align:-3px;">';
        }
        if ($iconType !== 'font' && preg_match('#^(https?://|/)#i', $icon)) {
            return '<img src="' . e($icon) . '" alt="' . e($title) . '" style="width:16px;height:16px;border-radius:3px;object-fit:cover;vertical-align:-3px;">';
        }
        return '<i class="' . e($icon) . '"></i>';
    }
}
$siteName = isset($settings['site_name']) ? $settings['site_name'] : '导航页款式 1';
$siteSubtitle = isset($settings['site_subtitle']) ? $settings['site_subtitle'] : '选择您要访问的网站';
$siteDescription = isset($settings['site_description']) ? $settings['site_description'] : '';
$copyright = isset($settings['copyright_text']) ? $settings['copyright_text'] : '';
$snowEnabled = isset($settings['snow_enabled']) && $settings['snow_enabled'] === '1';
$qqNumber = isset($settings['qq_number']) ? trim($settings['qq_number']) : '';
$qqGroup = isset($settings['qq_group']) ? trim($settings['qq_group']) : '';
$avatarUrl = 'https://placehold.co/172x172';
?>
<!doctype html>
<html lang="zh-CN">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <title><?php echo e($siteName); ?></title>
    <link rel="stylesheet" href="//oss2.myoss.top/assets/libs/fontawesome-free-6.7.2-web/css/all.css">
    <style>
        :root {
            --bg-start: #6d83c4;
            --bg-end: #c34e8a;
            --card-bg: #f7f7f7;
            --text-main: #4a4a4a;
            --subtext: #8d8d8d;
            --btn-start: #5f8df2;
            --btn-end: #8a4ee7;
        }

        * { box-sizing: border-box; }

        body {
            margin: 0;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            background:
                radial-gradient(circle at 18% 18%, rgba(255, 255, 255, 0.08), transparent 32%),
                radial-gradient(circle at 82% 32%, rgba(255, 255, 255, 0.08), transparent 35%),
                linear-gradient(135deg, var(--bg-start), var(--bg-end));
            font-family: "PingFang SC", "Microsoft YaHei", "Helvetica Neue", Arial, sans-serif;
            color: var(--text-main);
            padding: 16px;
        }

        .card {
            background: var(--card-bg);
            width: min(90vw, 520px);
            padding: 48px 40px 40px;
            border-radius: 16px;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.18);
            text-align: center;
        }

        .avatar {
            width: 86px;
            height: 86px;
            margin: 0 auto 24px;
            border-radius: 50%;
            border: 4px solid #fff;
            box-shadow: 0 8px 18px rgba(0, 0, 0, 0.16);
            overflow: hidden;
            background: #fff;
        }

        .avatar img { width: 100%; height: 100%; object-fit: cover; display: block; }

        h1 { margin: 0 0 12px; font-size: 28px; font-weight: 800; }
        .subtitle { margin: 0 0 28px; font-size: 14px; color: var(--subtext); }

        .action { display: flex; flex-direction: column; gap: 16px; }
        .action a {
            width: 80%;
            margin: 0 auto;
            display: block;
            text-decoration: none;
            color: #f2f2f2;
            font-size: 16px;
            font-weight: 600;
            letter-spacing: 0.5px;
            padding: 14px 18px;
            background: linear-gradient(90deg, var(--btn-start), var(--btn-end));
            border-radius: 8px;
            box-shadow: 0 10px 20px rgba(94, 141, 242, 0.25);
            transition: transform 0.15s ease, box-shadow 0.15s ease, filter 0.15s ease;
        }
        .action a:hover {
            transform: translateY(-2px);
            box-shadow: 0 12px 24px rgba(138, 78, 231, 0.28);
            filter: brightness(1.02);
        }
        .action .icon { margin-right: 8px; }

        .footer-note { margin-top: 22px; font-size: 13px; color: var(--subtext); line-height: 1.7; }
        #snowCanvas { position: fixed; inset: 0; z-index: 9999; pointer-events: none; }

        @media (max-width: 420px) {
            .card { padding: 38px 24px 32px; }
            h1 { font-size: 24px; }
            .action a { font-size: 15px; width: 90%; }
        }
    </style>
</head>
<body>
    <div class="card">
        <div class="avatar"><img src="<?php echo e($avatarUrl); ?>" alt="头像"></div>
        <h1><?php echo e($siteName); ?></h1>
        <p class="subtitle"><?php echo e($siteSubtitle); ?></p>
        <div class="action">
            <?php if (empty($links)): ?>
                <a href="javascript:void(0)">暂无导航链接</a>
            <?php else: ?>
                <?php foreach ($links as $item): ?>
                    <a href="<?php echo e(front_nav_href($item)); ?>" target="_blank">
                        <span class="icon"><?php echo tpl_icon_html($item['icon'], $item['title'], 'fa-solid fa-link', isset($item['icon_type']) ? $item['icon_type'] : ''); ?></span>
                        <?php echo e($item['title']); ?>
                    </a>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
        <div class="footer-note">
            <?php echo e($siteDescription); ?>
            <?php if ($qqNumber !== '' || $qqGroup !== ''): ?>
                <br>QQ：<?php echo e($qqNumber !== '' ? $qqNumber : '未设置'); ?>
                <?php if ($qqGroup !== ''): ?> | 群：<?php echo e($qqGroup); ?><?php endif; ?>
            <?php endif; ?>
            <?php if ($copyright !== ''): ?><br><?php echo e($copyright); ?><?php endif; ?>
        </div>
    </div>

<?php if ($snowEnabled): ?>
<canvas id="snowCanvas"></canvas>
<script>
(function () {
    var canvas = document.getElementById('snowCanvas');
    if (!canvas) return;
    var ctx = canvas.getContext('2d');
    var flakes = [];
    var count = 90;

    function resize() {
        canvas.width = window.innerWidth;
        canvas.height = window.innerHeight;
    }

    function reset(f) {
        f.x = Math.random() * canvas.width;
        f.y = Math.random() * canvas.height;
        f.r = 1 + Math.random() * 3;
        f.vx = -0.4 + Math.random() * 0.8;
        f.vy = 0.8 + Math.random() * 1.6;
    }

    for (var i = 0; i < count; i++) {
        var f = {};
        reset(f);
        flakes.push(f);
    }

    function draw() {
        ctx.clearRect(0, 0, canvas.width, canvas.height);
        ctx.fillStyle = 'rgba(255,255,255,0.85)';
        for (var i = 0; i < flakes.length; i++) {
            var f = flakes[i];
            f.x += f.vx;
            f.y += f.vy;
            if (f.y > canvas.height || f.x < -20 || f.x > canvas.width + 20) {
                reset(f);
                f.y = -10;
            }
            ctx.beginPath();
            ctx.arc(f.x, f.y, f.r, 0, Math.PI * 2);
            ctx.fill();
        }
        requestAnimationFrame(draw);
    }

    window.addEventListener('resize', resize);
    resize();
    draw();
})();
</script>
<?php endif; ?>
</body>
</html>
