<?php
require_once __DIR__ . "/../includes/inc.php";

$installed = is_installed();
?>
<!doctype html>
<html lang="zh-CN">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>安装向导 - 个人导航页系统</title>
    <script src="//oss2.myoss.top/assets/js/tailwind.js"></script>
    <script src="//oss2.myoss.top/assets/js/jquery.min.js"></script>
    <script src="//oss2.myoss.top/assets/libs/layer-v3.5.1/layer/layer.js"></script>
    <link rel="stylesheet" href="//oss2.myoss.top/assets/libs/fontawesome-free-6.7.2-web/css/all.css">
    <style>
        body { background: #f4f7fb; }
        .step-dot { width: 30px; height: 30px; border-radius: 9999px; display: inline-flex; align-items: center; justify-content: center; }
        .step-active { background: #2563eb; color: #fff; }
        .step-inactive { background: #dbeafe; color: #1e40af; }
    </style>
</head>
<body class="min-h-screen py-10">
<div class="max-w-4xl mx-auto px-4">
    <div class="bg-white rounded-xl shadow-lg overflow-hidden">
        <div class="p-6 border-b bg-blue-50">
            <h1 class="text-2xl font-bold text-blue-900">个人导航页系统安装向导</h1>
            <p class="text-sm text-slate-600 mt-1">步骤：用户协议 -> 环境检测 -> 安装配置 -> 安装成功</p>
        </div>

        <?php if ($installed): ?>
            <div class="p-8">
                <div class="rounded-lg bg-green-50 border border-green-200 p-6 text-green-800">
                    系统已安装。如需重装，请先删除 <code>install/install.lock</code>。
                </div>
                <div class="mt-5 flex gap-3">
                    <a href="/" class="px-4 py-2 rounded bg-blue-600 text-white">访问前台</a>
                    <a href="/admin/login.php" class="px-4 py-2 rounded bg-slate-700 text-white">进入后台</a>
                </div>
            </div>
        <?php else: ?>
        <div class="px-6 py-4 border-b flex items-center justify-between text-sm text-slate-700">
            <div class="flex items-center gap-3">
                <span class="step-dot step-active" data-step-dot="1">1</span>
                <span class="step-dot step-inactive" data-step-dot="2">2</span>
                <span class="step-dot step-inactive" data-step-dot="3">3</span>
                <span class="step-dot step-inactive" data-step-dot="4">4</span>
            </div>
            <span id="stepTitle" class="font-semibold">用户协议</span>
        </div>

        <div class="p-6">
            <div data-step="1">
                <div class="rounded border p-4 h-80 overflow-auto text-sm leading-7 text-slate-700 bg-slate-50">
                    <h2 class="font-semibold text-lg mb-3">用户协议</h2>
                    <p>1. 本系统仅供合法用途，请勿用于违反法律法规的业务。</p>
                    <p>2. 请自行保管后台账号密码，因管理不当造成的损失由使用者承担。</p>
                    <p>3. 系统会自动创建数据库文件、安装锁文件和上传目录。</p>
                    <p>4. 如需找回密码，可删除 install/install.lock 后重新安装初始化。</p>
                    <p>5. 点击下一步即视为你同意以上条款。</p>
                </div>
                <label class="mt-4 flex items-center gap-2 text-sm">
                    <input id="agree" type="checkbox" class="w-4 h-4">
                    <span>我已阅读并同意用户协议</span>
                </label>
                <div class="mt-5">
                    <button id="toStep2" class="px-4 py-2 rounded bg-blue-600 text-white">下一步</button>
                </div>
            </div>

            <div data-step="2" class="hidden">
                <div class="mb-4 flex items-center justify-between">
                    <h3 class="text-lg font-semibold">环境检测</h3>
                    <button id="recheckBtn" class="px-3 py-1.5 rounded border text-sm">重新检测</button>
                </div>
                <div class="overflow-x-auto">
                    <table class="w-full text-sm border">
                        <thead class="bg-slate-100">
                        <tr>
                            <th class="border p-2 text-left">检测项</th>
                            <th class="border p-2 text-left">要求</th>
                            <th class="border p-2 text-left">当前</th>
                            <th class="border p-2 text-left">结果</th>
                        </tr>
                        </thead>
                        <tbody id="checkTbody"></tbody>
                    </table>
                </div>
                <div id="checkMsg" class="mt-3 text-sm"></div>
                <div class="mt-5 flex gap-3">
                    <button class="px-4 py-2 rounded border" data-prev="1">上一步</button>
                    <button id="toStep3" class="px-4 py-2 rounded bg-blue-600 text-white">下一步</button>
                </div>
            </div>

            <div data-step="3" class="hidden">
                <h3 class="text-lg font-semibold mb-4">安装配置</h3>
                <form id="installForm" class="space-y-4 max-w-xl">
                    <div>
                        <label class="block text-sm mb-1">站点名称</label>
                        <input name="site_name" value="我的导航页" class="w-full border rounded px-3 py-2" maxlength="60">
                    </div>
                    <div>
                        <label class="block text-sm mb-1">管理员账号</label>
                        <input name="username" value="admin" class="w-full border rounded px-3 py-2" maxlength="20">
                    </div>
                    <div>
                        <label class="block text-sm mb-1">管理员密码</label>
                        <input type="password" name="password" value="123456" class="w-full border rounded px-3 py-2" minlength="6">
                    </div>
                    <div>
                        <label class="block text-sm mb-1">确认密码</label>
                        <input type="password" name="password2" value="123456" class="w-full border rounded px-3 py-2" minlength="6">
                    </div>
                </form>
                <div class="mt-5 flex gap-3">
                    <button class="px-4 py-2 rounded border" data-prev="2">上一步</button>
                    <button id="installBtn" class="px-4 py-2 rounded bg-blue-600 text-white">确认安装</button>
                </div>
            </div>

            <div data-step="4" class="hidden">
                <div class="rounded-lg border border-green-200 bg-green-50 p-6 text-green-800">
                    <div class="text-xl font-semibold">安装成功</div>
                    <p class="mt-2">系统已初始化完成，已自动生成数据库和安装锁文件。</p>
                </div>
                <div class="mt-5 flex gap-3">
                    <a href="/admin/login.php" class="px-4 py-2 rounded bg-blue-600 text-white">进入后台</a>
                    <a href="/" class="px-4 py-2 rounded bg-slate-700 text-white">查看前台</a>
                </div>
            </div>
        </div>
        <?php endif; ?>
    </div>
</div>

<?php if (!$installed): ?>
<script>
(function () {
    var currentStep = 1;
    var envPassed = false;
    var titles = {
        1: "用户协议",
        2: "环境检测",
        3: "安装配置",
        4: "安装成功"
    };

    function setStep(step) {
        currentStep = step;
        $('[data-step]').addClass('hidden');
        $('[data-step="' + step + '"]').removeClass('hidden');
        $('[data-step-dot]').removeClass('step-active').addClass('step-inactive');
        $('[data-step-dot]').each(function () {
            var num = parseInt($(this).attr('data-step-dot'), 10);
            if (num <= step) {
                $(this).removeClass('step-inactive').addClass('step-active');
            }
        });
        $('#stepTitle').text(titles[step]);
    }

    function renderChecks(list) {
        var html = '';
        for (var i = 0; i < list.length; i++) {
            var item = list[i];
            html += '<tr>' +
                '<td class="border p-2">' + item.name + '</td>' +
                '<td class="border p-2">' + item.required + '</td>' +
                '<td class="border p-2">' + item.current + '</td>' +
                '<td class="border p-2">' + (item.passed ? '<span class="text-green-600">通过</span>' : '<span class="text-red-600">失败：' + item.tips + '</span>') + '</td>' +
                '</tr>';
        }
        $('#checkTbody').html(html);
    }

    function checkEnv() {
        var loading = layer.msg('正在检测环境...', {icon: 16, shade: 0.2, time: 0});
        $.post('/install/ajax.php', {action: 'check_env'}, function (res) {
            layer.close(loading);
            if (res.code !== 1) {
                layer.msg(res.msg || '检测失败');
                return;
            }
            envPassed = !!res.data.passed;
            renderChecks(res.data.checks || []);
            if (envPassed) {
                $('#checkMsg').html('<span class="text-green-600">环境检测通过，可继续安装。</span>');
            } else {
                $('#checkMsg').html('<span class="text-red-600">环境检测未通过，请先修复后点击重新检测。</span>');
            }
        }, 'json').fail(function () {
            layer.close(loading);
            layer.msg('请求失败，请检查网络或 PHP 配置');
        });
    }

    $('#toStep2').on('click', function () {
        if (!$('#agree').prop('checked')) {
            layer.msg('请先勾选同意用户协议');
            return;
        }
        setStep(2);
        checkEnv();
    });

    $('#toStep3').on('click', function () {
        if (!envPassed) {
            layer.msg('环境检测未通过，不能继续');
            return;
        }
        setStep(3);
    });

    $('#recheckBtn').on('click', checkEnv);

    $('[data-prev]').on('click', function () {
        setStep(parseInt($(this).attr('data-prev'), 10));
    });

    $('#installBtn').on('click', function () {
        var formData = {
            action: 'do_install',
            site_name: $.trim($('#installForm [name="site_name"]').val()),
            username: $.trim($('#installForm [name="username"]').val()),
            password: $('#installForm [name="password"]').val(),
            password2: $('#installForm [name="password2"]').val()
        };

        if (formData.password !== formData.password2) {
            layer.msg('两次密码不一致');
            return;
        }

        var loading = layer.msg('安装中，请稍候...', {icon: 16, shade: 0.2, time: 0});
        $.post('/install/ajax.php', formData, function (res) {
            layer.close(loading);
            if (res.code !== 1) {
                layer.msg(res.msg || '安装失败');
                return;
            }
            setStep(4);
        }, 'json').fail(function () {
            layer.close(loading);
            layer.msg('安装请求失败');
        });
    });
})();
</script>
<?php endif; ?>
</body>
</html>
