<?php
require_once __DIR__ . '/../includes/inc.php';

$action = post('action', get('action'));

try {
    if ($action === 'check_env') {
        $result = Installer::checkEnvironment();
        json_response(1, '检测完成', $result);
    }

    if ($action === 'do_install') {
        if (file_exists(INSTALL_LOCK)) {
            json_response(0, '系统已安装，如需重装请先删除 install/install.lock');
        }

        $siteName = post('site_name', '我的导航页');
        $username = post('username', 'admin');
        $password = post('password', '123456');
        $password2 = post('password2', '123456');

        if ($password !== $password2) {
            json_response(0, '两次输入的密码不一致');
        }

        Installer::install($username, $password, $siteName);
        json_response(1, '安装成功');
    }

    json_response(0, '未知操作');
} catch (Exception $e) {
    json_response(0, $e->getMessage());
}
