<?php
require_once __DIR__ . '/includes/inc.php';

if (!is_installed()) {
    ?>
    <!doctype html>
    <html lang="zh-CN">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title>请先安装系统</title>
        <meta http-equiv="refresh" content="2;url=/install/">
        <style>
            body { margin: 0; font-family: Arial, sans-serif; background: #f5f6fb; display: flex; min-height: 100vh; align-items: center; justify-content: center; }
            .box { background: #fff; border-radius: 12px; padding: 28px; box-shadow: 0 8px 24px rgba(0,0,0,.08); max-width: 520px; }
            a { display: inline-block; margin-top: 12px; color: #2563eb; text-decoration: none; }
        </style>
    </head>
    <body>
    <div class="box">
        <h2>系统未安装</h2>
        <p>检测到缺少安装锁文件或数据库，请先完成安装。</p>
        <a href="/install/">点击进入安装向导</a>
        <p style="color:#888;font-size:12px;margin-top:8px;">2 秒后将自动跳转安装页面</p>
    </div>
    </body>
    </html>
    <?php
    exit;
}

try {
    $settings = Navigator::getSettings();
    $links = Navigator::frontLinks();
} catch (Exception $e) {
    http_response_code(500);
    echo '<h3>系统初始化失败：' . e($e->getMessage()) . '</h3>';
    exit;
}

try {
    VisitLogger::logPageView("/");
} catch (Exception $e) {
}

$template = isset($settings['theme_template']) ? $settings['theme_template'] : 'style2';
if (!in_array($template, array('style1', 'style2', 'style3', 'style15'), true)) {
    $template = 'style2';
}

$templateFile = __DIR__ . '/templates/' . $template . '.php';
if (!file_exists($templateFile)) {
    $templateFile = __DIR__ . '/templates/style2.php';
}

require $templateFile;
