<?php

class Database
{
    private static $instance = null;
    private $pdo;

    private function __construct()
    {
        if (!file_exists(DB_FILE)) {
            throw new Exception("数据库尚未初始化，请先安装系统");
        }

        $this->pdo = new PDO("sqlite:" . DB_FILE);
        $this->pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $this->pdo->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
    }

    public static function getInstance()
    {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    public function pdo()
    {
        return $this->pdo;
    }

    public function query($sql, $params = array())
    {
        $stmt = $this->pdo->prepare($sql);
        $index = 1;
        foreach ($params as $key => $value) {
            if (is_int($key)) {
                $stmt->bindValue($index, $value);
                $index++;
            } else {
                $paramKey = strpos($key, ":") === 0 ? $key : ":" . $key;
                $stmt->bindValue($paramKey, $value);
            }
        }
        $stmt->execute();
        return $stmt;
    }

    public function fetch($sql, $params = array())
    {
        $stmt = $this->query($sql, $params);
        $row = $stmt->fetch();
        return $row ? $row : array();
    }

    public function fetchAll($sql, $params = array())
    {
        $stmt = $this->query($sql, $params);
        return $stmt->fetchAll();
    }

    public function execute($sql, $params = array())
    {
        $stmt = $this->query($sql, $params);
        return $stmt->rowCount();
    }

    public function lastInsertId()
    {
        return (int)$this->pdo->lastInsertId();
    }
}
