<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

date_default_timezone_set("Asia/Shanghai");

if (!defined("ROOT_PATH")) {
    define("ROOT_PATH", dirname(__DIR__));
}
if (!defined("INCLUDES_PATH")) {
    define("INCLUDES_PATH", __DIR__);
}
if (!defined("DATA_PATH")) {
    define("DATA_PATH", INCLUDES_PATH . "/data");
}
if (!defined("DB_FILE")) {
    define("DB_FILE", DATA_PATH . "/app.sqlite");
}
if (!defined("INSTALL_LOCK")) {
    define("INSTALL_LOCK", ROOT_PATH . "/install/install.lock");
}
if (!defined("UPLOAD_DIR")) {
    define("UPLOAD_DIR", ROOT_PATH . "/bak");
}
if (!defined("UPLOAD_URL_PREFIX")) {
    define("UPLOAD_URL_PREFIX", "/bak");
}

spl_autoload_register(function ($class) {
    $file = INCLUDES_PATH . "/libs/" . $class . ".php";
    if (file_exists($file)) {
        require_once $file;
    }
});

function e($value)
{
    return htmlspecialchars((string)$value, ENT_QUOTES, "UTF-8");
}

function post($key, $default = "")
{
    return isset($_POST[$key]) ? trim((string)$_POST[$key]) : $default;
}

function get($key, $default = "")
{
    return isset($_GET[$key]) ? trim((string)$_GET[$key]) : $default;
}

function ensure_dir($path)
{
    if (!is_dir($path)) {
        @mkdir($path, 0755, true);
    }
    return is_dir($path) && is_writable($path);
}

function is_installed()
{
    return file_exists(INSTALL_LOCK) && file_exists(DB_FILE);
}

function redirect($url)
{
    header("Location: " . $url);
    exit;
}

function require_install_or_redirect()
{
    if (!is_installed()) {
        redirect("/install/");
    }
}

function require_admin_page_login()
{
    if (empty($_SESSION["admin_id"])) {
        redirect("/admin/login.php");
    }
}

function require_admin_ajax_login()
{
    if (empty($_SESSION["admin_id"])) {
        json_response(0, "未登录", array("redirect" => "/admin/login.php"));
    }
}

function json_response($code, $msg, $data = array())
{
    header("Content-Type: application/json; charset=utf-8");
    echo json_encode(
        array(
            "code" => (int)$code,
            "msg" => (string)$msg,
            "data" => is_array($data) ? $data : array("value" => $data)
        ),
        JSON_UNESCAPED_UNICODE
    );
    exit;
}

function front_nav_href($item)
{
    if (is_array($item) && isset($item["id"]) && (int)$item["id"] > 0) {
        return "/go.php?id=" . (int)$item["id"];
    }
    if (is_array($item) && isset($item["url"])) {
        return (string)$item["url"];
    }
    return "#";
}

function client_ip()
{
    $keys = array("HTTP_X_FORWARDED_FOR", "HTTP_CLIENT_IP", "REMOTE_ADDR");
    foreach ($keys as $key) {
        if (!empty($_SERVER[$key])) {
            $value = trim((string)$_SERVER[$key]);
            if ($key === "HTTP_X_FORWARDED_FOR") {
                $parts = explode(",", $value);
                $value = trim($parts[0]);
            }
            return substr($value, 0, 60);
        }
    }
    return "";
}
