<?php
require_once __DIR__ . '/../includes/inc.php';
require_install_or_redirect();
require_admin_page_login();

$pageTitle = '导航管理';
$activeMenu = 'nav_list';
require_once __DIR__ . '/head.php';
?>
<div class="card">
    <div class="card-header d-flex flex-wrap justify-content-between gap-2 align-items-center">
        <div class="d-flex gap-2">
            <input type="text" id="keyword" class="form-control form-control-sm" placeholder="搜索名称或链接" style="width:220px;">
            <button id="searchBtn" class="btn btn-sm btn-outline-primary">搜索</button>
        </div>
        <div class="d-flex gap-2">
            <button id="batchDeleteBtn" class="btn btn-sm btn-outline-danger">批量删除</button>
            <a href="/admin/nav_add.php" class="btn btn-sm btn-primary" target="_blank">新增导航</a>
        </div>
    </div>
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-striped table-hover mb-0">
                <thead>
                <tr>
                    <th class="px-3" width="50"><input type="checkbox" id="checkAll"></th>
                    <th width="60">ID</th>
                    <th>名称</th>
                    <th>链接</th>
                    <th width="90">图标类型</th>
                    <th>图标</th>
                    <th>排序</th>
                    <th>状态</th>
                    <th width="150">操作</th>
                </tr>
                </thead>
                <tbody id="listBody">
                <tr><td colspan="9" class="text-center text-secondary py-4">加载中...</td></tr>
                </tbody>
            </table>
        </div>
    </div>
</div>

<script>
function escapeHtml(text) {
    return $('<div>').text(text || '').html();
}

function loadList() {
    $.post('/admin/ajax.php', {
        action: 'nav_list',
        keyword: $.trim($('#keyword').val())
    }, function (res) {
        if (res.code !== 1) {
            layer.msg(res.msg || '加载失败');
            return;
        }

        var list = res.data.list || [];
        if (!list.length) {
            $('#listBody').html('<tr><td colspan="9" class="text-center text-secondary py-4">暂无数据</td></tr>');
            return;
        }

        var html = '';
        for (var i = 0; i < list.length; i++) {
            var item = list[i];
            var iconType = item.icon_type === 'image' ? '图片' : '字体';
            var iconPreview = '-';
            if (item.icon) {
                if (item.icon_type === 'image') {
                    iconPreview = '<img src=\"' + escapeHtml(item.icon) + '\" style=\"width:20px;height:20px;border-radius:4px;object-fit:cover;vertical-align:middle;\"> ' + escapeHtml(item.icon);
                } else {
                    iconPreview = '<i class=\"' + escapeHtml(item.icon) + '\"></i> ' + escapeHtml(item.icon);
                }
            }
            var status = item.is_visible == 1 ? '<span class="badge bg-success">显示</span>' : '<span class="badge bg-secondary">隐藏</span>';
            html += '<tr>' +
                '<td class="px-3"><input type="checkbox" class="row-check" value="' + item.id + '"></td>' +
                '<td>' + item.id + '</td>' +
                '<td>' + escapeHtml(item.title) + '</td>' +
                '<td><a href="' + escapeHtml(item.url) + '" target="_blank">' + escapeHtml(item.url) + '</a></td>' +
                '<td>' + iconType + '</td>' +
                '<td>' + iconPreview + '</td>' +
                '<td>' + (item.sort_order || 0) + '</td>' +
                '<td>' + status + '</td>' +
                '<td>' +
                    '<a href="/admin/nav_edit.php?id=' + item.id + '" class="btn btn-sm btn-outline-primary btn-op" target="_blank">编辑</a> ' +
                    '<button class="btn btn-sm btn-outline-danger btn-op" onclick="deleteOne(' + item.id + ')">删除</button>' +
                '</td>' +
                '</tr>';
        }
        $('#listBody').html(html);
    }, 'json').fail(function () {
        layer.msg('请求失败');
    });
}

function deleteOne(id) {
    layer.confirm('确认删除该条记录吗？', function () {
        $.post('/admin/ajax.php', {action: 'nav_delete', id: id}, function (res) {
            if (res.code !== 1) {
                layer.msg(res.msg || '删除失败');
                return;
            }
            layer.msg('删除成功');
            loadList();
        }, 'json').fail(function () {
            layer.msg('请求失败');
        });
    });
}

$('#searchBtn').on('click', loadList);
$('#keyword').on('keydown', function (e) {
    if (e.keyCode === 13) {
        loadList();
    }
});

$('#checkAll').on('change', function () {
    $('.row-check').prop('checked', $(this).prop('checked'));
});

$('#batchDeleteBtn').on('click', function () {
    var ids = [];
    $('.row-check:checked').each(function () {
        ids.push($(this).val());
    });

    if (!ids.length) {
        layer.msg('请先勾选要删除的数据');
        return;
    }

    layer.confirm('确认批量删除选中数据吗？', function () {
        $.post('/admin/ajax.php', {action: 'nav_batch_delete', ids: ids}, function (res) {
            if (res.code !== 1) {
                layer.msg(res.msg || '删除失败');
                return;
            }
            layer.msg('批量删除成功');
            loadList();
        }, 'json').fail(function () {
            layer.msg('请求失败');
        });
    });
});

loadList();
</script>
<?php require_once __DIR__ . '/end.php'; ?>
