<?php
require_once __DIR__ . '/../includes/inc.php';
require_install_or_redirect();
require_admin_page_login();

$pageTitle = '新增导航';
$activeMenu = 'nav_list';
require_once __DIR__ . '/head.php';
?>
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <span>新增导航</span>
        <a href="/admin/nav_list.php" class="btn btn-sm btn-outline-secondary">返回列表</a>
    </div>
    <div class="card-body">
        <form id="navForm" class="row g-3">
            <div class="col-12 col-md-6">
                <label class="form-label">网站名称</label>
                <input name="title" class="form-control" maxlength="100" required>
            </div>
            <div class="col-12 col-md-6">
                <label class="form-label">网站链接</label>
                <input name="url" class="form-control" placeholder="https://" required>
            </div>
            <div class="col-12 col-md-4">
                <label class="form-label">图标类型</label>
                <select name="icon_type" id="iconType" class="form-select">
                    <option value="font">字体图标</option>
                    <option value="image">图片图标</option>
                </select>
            </div>
            <div class="col-12">
                <label class="form-label">图标值</label>
                <div class="input-group">
                    <input name="icon" id="iconInput" class="form-control" placeholder="fa-solid fa-globe">
                    <input type="file" id="iconFile" class="form-control" accept="image/*">
                    <button type="button" id="uploadBtn" class="btn btn-outline-primary">上传图片</button>
                </div>
                <div class="form-text">字体图标示例：fa-solid fa-globe；图片图标可上传后自动填入 /bak/ 链接。</div>
            </div>
            <div class="col-12">
                <label class="form-label">描述</label>
                <textarea name="description" class="form-control" rows="2" maxlength="200"></textarea>
            </div>
            <div class="col-12 col-md-4">
                <label class="form-label">排序值（越大越靠前）</label>
                <input name="sort_order" type="number" class="form-control" value="0">
            </div>
            <div class="col-12 col-md-4 d-flex align-items-end">
                <div class="form-check">
                    <input class="form-check-input" type="checkbox" id="visibleCheck" checked>
                    <label class="form-check-label" for="visibleCheck">前台显示</label>
                </div>
            </div>
            <div class="col-12">
                <button type="submit" class="btn btn-primary">保存</button>
            </div>
        </form>
    </div>
</div>

<script>
$('#uploadBtn').on('click', function () {
    var file = $('#iconFile')[0].files[0];
    if (!file) {
        layer.msg('请先选择图片');
        return;
    }

    var formData = new FormData();
    formData.append('action', 'upload_image');
    formData.append('image', file);

    $.ajax({
        url: '/admin/ajax.php',
        type: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        dataType: 'json',
        success: function (res) {
            if (res.code !== 1) {
                layer.msg(res.msg || '上传失败');
                return;
            }
            $('#iconInput').val(res.data.url || '');
            $('#iconType').val('image');
            layer.msg('上传成功');
        },
        error: function () {
            layer.msg('上传请求失败');
        }
    });
});

$('#navForm').on('submit', function (e) {
    e.preventDefault();
    var formData = {
        action: 'nav_add',
        title: $.trim($(this).find('[name="title"]').val()),
        url: $.trim($(this).find('[name="url"]').val()),
        icon: $.trim($(this).find('[name="icon"]').val()),
        icon_type: $.trim($(this).find('[name="icon_type"]').val()),
        description: $.trim($(this).find('[name="description"]').val()),
        sort_order: $.trim($(this).find('[name="sort_order"]').val()),
        is_visible: $('#visibleCheck').prop('checked') ? 1 : 0
    };

    $.post('/admin/ajax.php', formData, function (res) {
        if (res.code !== 1) {
            layer.msg(res.msg || '保存失败');
            return;
        }
        layer.msg('保存成功');
        setTimeout(function () {
            location.href = '/admin/nav_list.php';
        }, 500);
    }, 'json').fail(function () {
        layer.msg('请求失败');
    });
});
</script>
<?php require_once __DIR__ . '/end.php'; ?>
