<?php
require_once __DIR__ . '/../includes/inc.php';

if (!is_installed()) {
    redirect('/install/');
}

if (!empty($_SESSION['admin_id'])) {
    redirect('/admin/index.php');
}
?>
<!doctype html>
<html lang="zh-CN">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>后台登录</title>
    <link rel="stylesheet" href="https://oss2.myoss.top/assets/libs/bootstrap-5.3.5-dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="//oss2.myoss.top/assets/libs/fontawesome-free-6.7.2-web/css/all.css">
    <script src="//oss2.myoss.top/assets/js/jquery.min.js"></script>
    <script src="//oss2.myoss.top/assets/libs/layer-v3.5.1/layer/layer.js"></script>
    <script src="https://oss2.myoss.top/assets/libs/bootstrap-5.3.5-dist/js/bootstrap.bundle.min.js"></script>
    <style>
        body {
            min-height: 100vh;
            background: linear-gradient(135deg, #0ea5e9, #2563eb);
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        .login-card { width: 100%; max-width: 430px; border: 0; border-radius: 16px; }
    </style>
</head>
<body>
<div class="card login-card shadow-lg">
    <div class="card-body p-4 p-md-5">
        <h1 class="h4 mb-1">后台登录</h1>
        <p class="text-secondary small mb-4">默认账号：admin 默认密码：123456</p>

        <form id="loginForm" autocomplete="off">
            <div class="mb-3">
                <label class="form-label">账号</label>
                <input type="text" name="username" class="form-control" value="admin" maxlength="20" required>
            </div>
            <div class="mb-3">
                <label class="form-label">密码</label>
                <input type="password" name="password" class="form-control" value="123456" required>
            </div>
            <button type="submit" class="btn btn-primary w-100">登 录</button>
        </form>
        <div class="text-center mt-3">
            <a href="/" class="small text-decoration-none">返回前台</a>
        </div>
    </div>
</div>
<script>
$('#loginForm').on('submit', function (e) {
    e.preventDefault();
    var formData = {
        action: 'login',
        username: $.trim($(this).find('[name="username"]').val()),
        password: $(this).find('[name="password"]').val()
    };

    var loading = layer.msg('登录中...', {icon: 16, shade: 0.2, time: 0});
    $.post('/admin/ajax.php', formData, function (res) {
        layer.close(loading);
        if (res.code !== 1) {
            layer.msg(res.msg || '登录失败');
            return;
        }
        location.href = '/admin/index.php';
    }, 'json').fail(function () {
        layer.close(loading);
        layer.msg('请求失败，请稍后再试');
    });
});
</script>
</body>
</html>
