<?php
if (!isset($pageTitle)) {
    $pageTitle = '后台管理';
}
if (!isset($activeMenu)) {
    $activeMenu = '';
}
$adminUsername = isset($_SESSION['admin_username']) ? $_SESSION['admin_username'] : 'admin';
?>
<!doctype html>
<html lang="zh-CN">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo e($pageTitle); ?> - 个人导航页后台</title>
    <link rel="stylesheet" href="https://oss2.myoss.top/assets/libs/bootstrap-5.3.5-dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="//oss2.myoss.top/assets/libs/fontawesome-free-6.7.2-web/css/all.css">
    <script src="//oss2.myoss.top/assets/js/jquery.min.js"></script>
    <script src="//oss2.myoss.top/assets/libs/layer-v3.5.1/layer/layer.js"></script>
    <script src="https://oss2.myoss.top/assets/libs/bootstrap-5.3.5-dist/js/bootstrap.bundle.min.js"></script>
    <style>
        :root {
            --admin-top-h: 56px;
            --admin-side-w: 240px;
            --admin-bg: #f3f5fa;
            --admin-side-bg: #111827;
            --admin-side-text: #d1d5db;
            --admin-side-active: #1d4ed8;
        }
        body { background: var(--admin-bg); }
        .admin-top {
            height: var(--admin-top-h);
            background: #fff;
            border-bottom: 1px solid #e5e7eb;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            z-index: 1030;
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 0 14px;
        }
        .admin-brand { font-weight: 700; color: #111827; }
        .admin-sidebar {
            position: fixed;
            left: 0;
            top: var(--admin-top-h);
            width: var(--admin-side-w);
            height: calc(100vh - var(--admin-top-h));
            background: var(--admin-side-bg);
            color: var(--admin-side-text);
            overflow-y: auto;
            transition: transform .2s ease;
            z-index: 1020;
        }
        .admin-menu {
            list-style: none;
            margin: 0;
            padding: 10px;
        }
        .admin-menu a {
            display: block;
            color: var(--admin-side-text);
            text-decoration: none;
            border-radius: 8px;
            padding: 10px 12px;
            margin-bottom: 6px;
            font-size: 14px;
        }
        .admin-menu a:hover { background: rgba(255, 255, 255, .08); color: #fff; }
        .admin-menu a.active { background: var(--admin-side-active); color: #fff; }
        .admin-main {
            margin-top: var(--admin-top-h);
            margin-left: var(--admin-side-w);
            padding: 16px;
            min-height: calc(100vh - var(--admin-top-h));
            transition: margin-left .2s ease;
        }
        .card { border: 0; box-shadow: 0 4px 14px rgba(22, 34, 51, .05); }
        .table td, .table th { vertical-align: middle; }
        .btn-op { padding: .2rem .45rem; font-size: .75rem; }

        body.sidebar-collapsed .admin-sidebar { transform: translateX(-100%); }
        body.sidebar-collapsed .admin-main { margin-left: 0; }

        @media (max-width: 991.98px) {
            .admin-sidebar { transform: translateX(-100%); }
            .admin-main { margin-left: 0; }
            body.sidebar-open .admin-sidebar { transform: translateX(0); }
        }
    </style>
    <script>
        window.ADMIN_AJAX = '/admin/ajax.php';
        function ajaxFailMessage(xhr) {
            if (xhr && xhr.responseJSON && xhr.responseJSON.msg) {
                return xhr.responseJSON.msg;
            }
            return '请求失败，请稍后重试';
        }
        function doLogout() {
            $.post(window.ADMIN_AJAX, {action: 'logout'}, function (res) {
                if (res.code === 1) {
                    location.href = '/admin/login.php';
                } else {
                    layer.msg(res.msg || '退出失败');
                }
            }, 'json').fail(function (xhr) {
                layer.msg(ajaxFailMessage(xhr));
            });
        }
        function toggleSidebar() {
            if (window.matchMedia('(max-width: 991.98px)').matches) {
                document.body.classList.toggle('sidebar-open');
            } else {
                document.body.classList.toggle('sidebar-collapsed');
            }
        }
        document.addEventListener('click', function (e) {
            if (window.matchMedia('(max-width: 991.98px)').matches) {
                var sidebar = document.querySelector('.admin-sidebar');
                var toggler = document.querySelector('#sidebarToggler');
                if (document.body.classList.contains('sidebar-open') && sidebar && !sidebar.contains(e.target) && toggler && !toggler.contains(e.target)) {
                    document.body.classList.remove('sidebar-open');
                }
            }
        });
    </script>
</head>
<body>
<header class="admin-top">
    <div class="d-flex align-items-center gap-3">
        <button id="sidebarToggler" type="button" class="btn btn-sm btn-outline-secondary" onclick="toggleSidebar()">
            <i class="fa-solid fa-bars"></i>
        </button>
        <span class="admin-brand">导航系统后台</span>
    </div>
    <div class="d-flex align-items-center gap-2">
        <span class="text-secondary small">当前用户：<?php echo e($adminUsername); ?></span>
    </div>
</header>

<aside class="admin-sidebar">
    <ul class="admin-menu">
        <li><a class="<?php echo $activeMenu === 'dashboard' ? 'active' : ''; ?>" href="/admin/index.php"><i class="fa-solid fa-gauge me-2"></i>仪表盘</a></li>
        <li><a class="<?php echo $activeMenu === 'nav_list' ? 'active' : ''; ?>" href="/admin/nav_list.php"><i class="fa-solid fa-list me-2"></i>导航管理</a></li>
        <li><a class="<?php echo $activeMenu === 'template' ? 'active' : ''; ?>" href="/admin/template.php"><i class="fa-solid fa-palette me-2"></i>前台模板</a></li>
        <li><a class="<?php echo $activeMenu === 'report' ? 'active' : ''; ?>" href="/admin/report.php"><i class="fa-solid fa-chart-column me-2"></i>访问报表</a></li>
        <li><a class="<?php echo $activeMenu === 'settings' ? 'active' : ''; ?>" href="/admin/set.php"><i class="fa-solid fa-gear me-2"></i>系统设置</a></li>
        <li><a class="<?php echo $activeMenu === 'password' ? 'active' : ''; ?>" href="/admin/password.php"><i class="fa-solid fa-key me-2"></i>修改密码</a></li>
        <li><a href="javascript:void(0)" onclick="doLogout()"><i class="fa-solid fa-right-from-bracket me-2"></i>退出登录</a></li>
    </ul>
</aside>

<main class="admin-main">
    <div class="container-fluid px-0">
